<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreColonneInEvidenza extends VisualizzatoreComponente {
        private $gestoreTraduzioni;
        private $linguaCorrente;
        
        function __construct($db) {
            parent::__construct($db);
        }

        function generaContenutoSezione($dati) {
            
            $impostazioniAspetto = parent::getDb()->leggiSingolaRiga("geecB_impostazioni",1);
            $datiColonneEvidenza =parent::getDb()->leggiSingolaRiga("geec_colonneInEvidenza",$dati["idElemento"]);

            if($datiColonneEvidenza["primaColonna"]==0) {
                parent::messaggioDiErrore("Attenzione, questo componente <strong>colonne in evidenza</strong> non è stato configurato, configuralo dall'area amministrativa ");
            }
            else {

                $queryNomiTag = "SELECT * FROM geecB_contenuti WHERE id={$datiColonneEvidenza["primaColonna"]}";
                $risProfili = parent::getDb()->eseguiQueryLettura($queryNomiTag);
                $articolo1 = $risProfili->fetch_assoc();
                
                $queryNomiTag = "SELECT * FROM geecB_contenuti WHERE id={$datiColonneEvidenza["secondaColonna"]}";
                $risProfili = parent::getDb()->eseguiQueryLettura($queryNomiTag);
                $articolo2 = $risProfili->fetch_assoc();

                $queryNomiTag = "SELECT * FROM geecB_contenuti WHERE id={$datiColonneEvidenza["terzaColonna"]}";
                $risProfili = parent::getDb()->eseguiQueryLettura($queryNomiTag);
                $articolo3 = $risProfili->fetch_assoc();

                $queryNomiTag = "SELECT * FROM geecB_contenuti WHERE id={$datiColonneEvidenza["quartaColonna"]}";
                $risProfili = parent::getDb()->eseguiQueryLettura($queryNomiTag);
                $articolo4 = $risProfili->fetch_assoc();

                $carattere = substr($datiColonneEvidenza['classeColonne'], -1, 1);
                $numeroColonne = (int)$carattere;

                echo"<div class=\"{$datiColonneEvidenza['spazioOccupato']}\">
                        <div class=\"row\">
                        <div class=\"col-12 mb-3 text-center\">
                            <h2 class=\"separatore-inferiore\" >{$datiColonneEvidenza['nome']}</h2>
                        </div>";

                        $linkArticolo1 = GeneratoreUrl::creaUrlContenuto($articolo1, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);
                        StampaContenuti::contenutiAffiancati($this->gestoreTraduzioni,$articolo1, $linkArticolo1, $datiColonneEvidenza['classeColonne'], "si",$datiColonneEvidenza['testoPrimaColonna']." ");

                        if($numeroColonne<7 && $datiColonneEvidenza['classeColonne']!="col-lg-8 mx-auto") {
                            $linkArticolo2 = GeneratoreUrl::creaUrlContenuto($articolo2, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);
                            StampaContenuti::contenutiAffiancati($this->gestoreTraduzioni,$articolo2, $linkArticolo2, $datiColonneEvidenza['classeColonne'], "si",$datiColonneEvidenza['testoSecondaColonna']." ");  
                        }
                        if($numeroColonne<5 && $datiColonneEvidenza['classeColonne']!="col-lg-8 mx-auto") {
                            $linkArticolo3 = GeneratoreUrl::creaUrlContenuto($articolo3, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);
                            StampaContenuti::contenutiAffiancati($this->gestoreTraduzioni,$articolo3, $linkArticolo3, $datiColonneEvidenza['classeColonne'], "si",$datiColonneEvidenza['testoTerzaColonna']." ");  
                        }      
                        if($numeroColonne<4 && $datiColonneEvidenza['classeColonne']!="col-lg-8 mx-auto") {    
                            $linkArticolo4 = GeneratoreUrl::creaUrlContenuto($articolo4, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);
                            StampaContenuti::contenutiAffiancati($this->gestoreTraduzioni,$articolo4, $linkArticolo4, $datiColonneEvidenza['classeColonne'], "si",$datiColonneEvidenza['testoQuartaColonna']." ");
                        }
                    echo"</div>
                    </div>";
            }
        }
        
        // getter & setter
        public function getGestoreTraduzioni() {
            return $this->gestoreTraduzioni;
        }

        public function getLinguaCorrente() {
            return $this->linguaCorrente;
        }

        public function setGestoreTraduzioni($gestoreTraduzioni): void {
            $this->gestoreTraduzioni = $gestoreTraduzioni;
        }

        public function setLinguaCorrente($linguaCorrente): void {
            $this->linguaCorrente = $linguaCorrente;
        }
    }
